import six
from random import randrange
from kernel.util.unittest import TestCase, main
from kernel.util.streams.streambase import StreamBase


class TestStream(TestCase):
    def testInts(self):
        for suffix in ("SInt", "FInt", "LInt", "NInt", "BELInt"):
            written = []
            slave = six.moves.cStringIO()
            stream = StreamBase(slave)
            r, w = getattr(stream, "read{0}".format(suffix)), getattr(stream, "write{0}".format(suffix))
            for i in range(100):
                written.append(randrange(1 << 32))
                w(written[-1])
            slave.reset()
            for i in written:
                self.assertEqual(i, r())

    def testStrings(self):
        strings = ["adlsak;dlsad", "owepkwqeio1209i90jLKdl", "alkdjwalkewqjekwq" * 999, ""]
        slave = six.moves.cStringIO()
        stream = StreamBase(slave)
        for s in strings:
            stream.writeStr(s)
        slave.reset()
        for s in strings:
            self.assertEqual(s, stream.readStr())

if __name__ == '__main__':
    main()
