import time
import threading  # noqa


def joinall(threads, timeout=None):
    """
    Join a list of threads with optional timeout.

    :arg iterable threads: List of threads
    :arg float timeout: Timeout in seconds

    :rtype: bool, True if all threads joined, False if at least 1 timed out.
    """
    if timeout is None:
        return [thr.join() for thr in threads]

    assert isinstance(timeout, (int, float))
    assert timeout > 0

    start = time.time()
    deadline = start + timeout

    for thr in threads:
        timeout = deadline - time.time()
        if timeout < 0:
            return False

        thr.join(timeout=deadline - time.time())

    return not any([thr.isAlive() for thr in threads])
