from __future__ import absolute_import

import os


from . import logging
from .config import Config
from .functional import singleton

from pkg_resources import require, DistributionNotFound

try:
    require('unittest2')
    import unittest2 as unittest
    from unittest2 import *  # noqa
except (ImportError, DistributionNotFound):
    import unittest
    from unittest import *  # noqa


cfg = Config(
    'ya.skynet.util.unittest',
    """
Skip: []
LogLevel: 3
    """,
    searchPackages=['kernel.util', 'ya.skynet.util']
)

slow = unittest.skipIf('slow' in cfg.Skip, 'slow')
net = unittest.skipIf('net' in cfg.Skip, 'net')
posixOnly = unittest.skipIf(os.name != 'posix', 'Posix only')


@singleton
def installLogger():
    logging.initialize(level=logging.FATAL - cfg.LogLevel * 10)


class TestCase(unittest.TestCase):
    def setUp(self):
        installLogger()
