from .stop import Stop
from .nointr import noIntr


def async(path, srv):  # noqa: W606
    import zmq
    from . import fixpath, context

    s = context.Context().socket(zmq.PULL)
    s.bind(fixpath.fix(path))

    while True:
        (name, args, kwargs) = noIntr(s.recv_pyobj)

        try:
            getattr(srv, name)(*args, **kwargs)
        except Stop:
            break
        except Exception:
            pass


class Func(object):
    def __init__(self, name, parent):
        self.name = name
        self.parent = parent

    def __call__(self, *args, **kwargs):
        self.parent.s.send_pyobj((self.name, args, kwargs))


class AsyncCall(object):
    def __init__(self, path):
        import zmq
        from . import fixpath, context

        s = context.Context().socket(zmq.PUSH)
        s.setsockopt(zmq.LINGER, 0)
        s.connect(fixpath.fix(path))

        self.s = s

    def __getattr__(self, name):
        if name.startswith('__'):
            raise AttributeError(name)

        return Func(name, self)
