from kernel.util.functional import memoized


@memoized
def getTempDir():
    from api.srvmngr import getRoot

    return getRoot()


def fix(path):
    if path.startswith('global://'):
        ret = 'ipc://' + getTempDir().rstrip('/') + '/var/' + path[8:].lstrip('/')

        if len(ret) > 100:
            import hashlib
            return 'ipc:///tmp/' + hashlib.md5(ret).hexdigest()

        return ret

    return path


def pathForHB(path):
    if path.startswith('ipc://'):
        return path + '.hb'

    (path, sep, port) = path.rpartition(':')

    return path + sep + str(long(port) + 1)
