"""Public / private keys routines"""

from ._key_base import AuthKey, PKey, CryptoKey, bytesio

try:
    from ._key_crypto import RSAKey, DSSKey
    from ._cert_crypto import Certificate
except ImportError:
    from ._key_cryptography import RSAKey, DSSKey
    from ._cert_cryptography import Certificate

from ._key_ecdsa import ECDSAKey, _ecdsa_kind

__all__ = [
    'AuthKey',
    'PKey',
    'CryptoKey',
    'RSAKey',
    'DSSKey',
    'ECDSAKey',
    'Certificate',
    '_ecdsa_kind',
    'bytesio',
]
