"""Temporary key for auth managers"""

from kernel.util.sys.user import getUserName
from .sign import gSignManager
from .verify import gVerifyManager
from .key import RSAKey


__default__ = object()


class TempKey(object):
    """
    Adds new test key to auth manager on __enter__ and removes it on __exit__
    """

    def __init__(self, signManager=__default__, verifyManager=__default__, bits=None, keyClass=RSAKey):
        """
        :type signManager: .sign.SignManager or None
        :type verifyManager: .verify.VerifyManager or None
        :param AuthManager authManager:
        """
        if signManager is __default__:
            signManager = gSignManager()
        if verifyManager is __default__:
            verifyManager = gVerifyManager()
        self.__signManager = signManager
        self.__verifyManager = verifyManager
        self.__key = keyClass.generate(bits)
        self.__key.userNames.add(getUserName())

    def __enter__(self):
        for manager in (self.__signManager, self.__verifyManager):
            if manager:
                manager.addKey(self.__key)
        return self.__key

    def __exit__(self, *args):
        for manager in (self.__signManager, self.__verifyManager):
            if manager:
                manager.removeKey(self.__key.fingerprint())
