"""
Wrappers around
"""

import os

try:
    import api.copier
    copierExceptions = (api.copier.CopierError, EnvironmentError, RuntimeError)
    Copier = api.copier.Copier
    CopierError = api.copier.CopierError
except ImportError:
    copierExceptions = (EnvironmentError, RuntimeError)
    CopierError = None

    def Copier(*args, **kwargs):
        raise RuntimeError("copier is not available")


from kernel.util.functional import reliable


@reliable(exceptions=copierExceptions, timeout=5)
def copierList(resid):
    """
    Reliable call to copier.list
    """
    copier = Copier()
    files = copier.list(resid).files()
    if not files or not isinstance(files, list):
        raise EnvironmentError(
            'Empty files list received from copier for id \"{}\"'.format(resid))
    return files


@reliable(exceptions=copierExceptions, timeout=5)
def copierGet(resId, destination):
    """
    Reliable call to copier.get
    """
    copier = Copier()
    copier.get(resId, destination).wait()
    listResult = list(copier.list(resId).files())
    if not listResult:
        raise EnvironmentError("Empty file list received from copier for id {0}".format(resId))
    return [os.path.join(destination, f["name"]) for f in listResult]


@reliable(exceptions=CopierError, timeout=5)
def copierShare(files):
    """
    Reliable copier share
    """
    copier = Copier()
    return copier.create(files).resid()
