from kernel.util.functional import reliable
from six.moves.xmlrpc_client import Error as XMLRPCError

from ..copier.helpers import copierExceptions, copierGet  # noqa backward compat

rpcErrors = (EnvironmentError, RuntimeError, XMLRPCError)

__all__ = ['copierGet', 'copierExceptions', 'constRpcCall']


@reliable(5, rpcErrors, 0.01)
def constRpcCall(func, *args, **kwargs):
    """
    Reliable call to some const (guaranty of safe retries) rpc function
    """
    return func(*args, **kwargs)
