import sys

from kernel.util.misc import size2str

from . import CmdCopier, pbModule


class CmdShare(CmdCopier):
    usage = '\n'.join((
        'file_path [, file_path2, ...]',
        'Examples:',
        '   sky share /etc/passwd /etc/hosts',
        '   sky share -d /etc hosts'
    ))
    mode = 'share'
    description = 'create copier torrent'

    def __init__(self):
        super(CmdShare, self).__init__()

        self.parser.add_option(
            '-T', '--transport', dest='transport', action='store', default=None,
            help='Transport to use for sharing (use "help" to list all)'
        )
        self.parser.add_option(
            '-d', '--dir', dest='dir', action='store', default=None,
            help='Directory to start searching files from (cwd)'
        )
        self.parser.add_option(
            '-a', '--archive', dest='archive', action='store_true', default=False,
            help='Save symlinks as is.'
        )
        self.parser.add_option(
            '--sign', action='store_true',
            help='Sign resource with ECDSA key. Will generate new one unless --sign-key specified'
        )
        self.parser.add_option(
            '--sign-key', action='store', default=None,
            help='Sign with specified key'
        )

        self._add_progress_args()

    def hashing_progress_meter(self, total_bytes, hashed_bytes):
        pb = pbModule()
        if not self._progressBar:
            size_label = pb.FormatLabel('[%(hashed)s]')
            size_label.mapping['hashed'] = ('currval', size2str)
            widgets = [
                '  [', pb.AnimatedMarker(), ']', ' Hashing ', size_label,
                ' [', pb.FileTransferSpeed(), '] ',
                pb.Bar(marker='='), ' [', pb.ETA(), '] ', pb.Percentage(), '  '
            ]
            self._progressBar = pb.ProgressBar(widgets=widgets, maxval=total_bytes).start()
        self._progressBar.update(hashed_bytes)

    def run(self):
        import api.copier

        if self.options.transport is None:
            from api.config import copierTransport
            self.options.transport = copierTransport()

        if self.options.transport == 'help':
            print >> sys.stderr
            print >> sys.stderr, 'Supported transports:'
            print >> sys.stderr, '(you can switch them via -T/--transport argument during sharing)'
            print >> sys.stderr

            for magicks, doc in api.copier.copierClass().transports_info():
                print >> sys.stderr, '  ' + ', '.join(m + ':' for m in sorted(magicks))
                formatted_doc = [
                    ' ' * 6 + l.strip() for l in doc.split('\n')
                    if l.strip()
                ]
                if not formatted_doc:
                    print >> sys.stderr, ' ' * 6 + 'No documentation.\n'
                else:
                    print >> sys.stderr, '\n'.join(formatted_doc) + '\n'

            return 0

        if not len(self.argv):
            print >> sys.stderr, 'Error: you must specify at least 1 path\n'
            self.help()
            return 1

        try:
            if self.options.progress:
                self.create_handle_progress(version=self.options.progress_version)

            if self.options.sign_key:
                sign = self.options.sign_key
            elif self.options.sign:
                sign = True
            else:
                sign = False

            if not self.options.archive:
                handle = api.copier.Copier().createEx(
                    list(self.argv),
                    cwd=self.options.dir,
                    transport=self.options.transport,
                    sign=sign,
                    **self.opts
                )
            else:
                handle = api.copier.Copier().createExEx(
                    list(self.argv),
                    cwd=self.options.dir,
                    transport=self.options.transport,
                    sign=sign,
                    **self.opts
                )

            if self.options.progress:
                self.create_handle_progress(version=self.options.progress_version, done=True)

            if self.options.progress:
                self._handle_progress(
                    handle,
                    freq=self.options.progress_report_freq,
                    version=self.options.progress_version
                )

            result = handle.wait()
            resid = result.resid()
            sign_key = result.key()

        except Exception as err:
            code = self.analyze_error(err)
            return self.print_error(err, code)

        print resid

        if sign_key:
            print(sign_key)
