import unittest
from library.sky.hosts import braceExpansion


class TestHosts(unittest.TestCase):
    def setUp(self):
        self.test_results = [
            (['xxx-{0000..0002}.yyy.ru'], ['xxx-0000.yyy.ru', 'xxx-0001.yyy.ru', 'xxx-0002.yyy.ru']),
            (['xxx-{0010..0012}.yyy.ru'], ['xxx-0010.yyy.ru', 'xxx-0011.yyy.ru', 'xxx-0012.yyy.ru']),
            (['xxx-{0100..0102}.yyy.ru'], ['xxx-0100.yyy.ru', 'xxx-0101.yyy.ru', 'xxx-0102.yyy.ru']),
            (['xxx-{1000..1002}.yyy.ru'], ['xxx-1000.yyy.ru', 'xxx-1001.yyy.ru', 'xxx-1002.yyy.ru']),
            (['xxx-{0..0002}.yyy.ru'],    ['xxx-0000.yyy.ru', 'xxx-0001.yyy.ru', 'xxx-0002.yyy.ru']),
            (['xxx-{10..0012}.yyy.ru'],   ['xxx-0010.yyy.ru', 'xxx-0011.yyy.ru', 'xxx-0012.yyy.ru']),
            (['xxx-{100..0102}.yyy.ru'],  ['xxx-0100.yyy.ru', 'xxx-0101.yyy.ru', 'xxx-0102.yyy.ru']),
            (['xxx-{0000..2}.yyy.ru'],    ['xxx-0000.yyy.ru', 'xxx-0001.yyy.ru', 'xxx-0002.yyy.ru']),
            (['xxx-{0010..12}.yyy.ru'],   ['xxx-0010.yyy.ru', 'xxx-0011.yyy.ru', 'xxx-0012.yyy.ru']),
            (['xxx-{0100..102}.yyy.ru'],  ['xxx-0100.yyy.ru', 'xxx-0101.yyy.ru', 'xxx-0102.yyy.ru']),
            (['xxx-{000100..102}.yyy.ru'], ['xxx-000100.yyy.ru', 'xxx-000101.yyy.ru', 'xxx-000102.yyy.ru']),
            (['xxx-{100..000102}.yyy.ru'], ['xxx-000100.yyy.ru', 'xxx-000101.yyy.ru', 'xxx-000102.yyy.ru']),
        ]

    def test_brace_expansion(self):
        for expr, result in self.test_results:
            self.assertEqual(braceExpansion(expr), result)


if __name__ == '__main__':
    unittest.main()
