import sys


class StderrRedirect(object):
    def __init__(self, stream):
        self._redirected = stream != sys.stderr
        self._initial_stderr = sys.stderr
        self._stream = stream

    def __enter__(self):
        if self._redirected:
            sys.stderr = self._stream

    def __exit__(self, excType, excValue, traceback):
        if self._redirected:
            sys.stderr = self._initial_stderr


def printOutputMessage(title, message=None, additional=None, error=False):
    equalsMessagesDivider = '=' * 80 + '\n'
    minusMessageDivider = '-' * 80 + '\n'

    stream = (sys.stdout if not error else sys.stderr)
    stream.write(equalsMessagesDivider)
    stream.write(title)
    stream.write('\n')
    if additional is not None:
        stream.write(minusMessageDivider)
        if additional:
            stream.write(additional)
            stream.write('\n')
    if message is not None:
        stream.write(minusMessageDivider)
        if message:
            stream.write(message)
            stream.write('\n')
    stream.write(equalsMessagesDivider)
    stream.write('\n')
    try:
        stream.flush()
    except IOError:
        pass


def printUnresolvedHosts(unresolvedHosts):
    if unresolvedHosts:
        printOutputMessage(
            'Failure on %d host(s): %s' % (
                len(unresolvedHosts),
                ' '.join(('%s' % i for i in unresolvedHosts))
            ),
            "Can't resolve hostname",
            error=True
        )
