# -*- coding: utf-8 -*-
import os
from api.copier import Copier


class DownloadRunner(object):
    """
    Расшарить торрент с удалённого сервера.
    В качестве результата задача возвращает torrentid.

    :param str srcPath: путь к файлу или каталогу на удалённом сервере.
                        В торренте будет находиться только последняя часть
                        (basename) этого пути — для пути ``/path/to/something``
                        будет создан торрент с содержимым ``/something``.
    """
    def __init__(self, srcPath):
        self.srcPath = srcPath

    def run(self):
        parts = os.path.split(self.srcPath)
        return Copier().create([parts[1]], cwd=parts[0]).resid()
