# -*- coding: utf-8 -*-
import os
import multiprocessing


class LoadAvgRunner:
    """
    Получить информацию о загрузке системы.
    В обычном режиме возвращает среднюю загрузку системы за последнюю минуту.
    В расширенном режиме возвращает кортеж из:

        - средняя загрузка системы за минуту
        - количество ядер на машине
        - средняя загрузка ядра

    :param bool extended: флаг, указывающий необходимость расширенной информации
    """
    def __init__(self, extended=False):
        self.extended = extended

    def run(self):
        loadAverage1, loadAverage5, loadAverage15 = os.getloadavg()
        if self.extended:
            CPUCount = multiprocessing.cpu_count()
            loadPerCPU = (float(loadAverage1) / float(CPUCount))
            return loadAverage1, CPUCount, loadPerCPU
        return loadAverage1
