"""
Wrapper for the IRemoteObject and self-descendants, which will proxy default properties
"""

__author__ = 'torkve'

from api.cqueue.remoteobject import IRemoteObject


class RemoteObjectWrapper(object):
    class __metaclass__(type):
        def __new__(mcs, cls, bases, dct):
            for x in dir(IRemoteObject):
                if mcs._validProp(x) and x not in dct:
                    dct[x] = mcs._genProp(x)

            # 'run' is not exposed by IRemoteObject but required
            # for backward compatibility with kqueue
            if 'run' not in dct:
                dct['run'] = mcs._genProp('run')

            # __iter__ and __call__ should be processed separately, since they produce other exceptions
            dct['__call__'] = lambda self: self.slave()
            dct['__iter__'] = lambda self: iter(self.slave)

            return type(cls, bases, dct)

        @staticmethod
        def _validProp(x):
            return (not x.startswith('_')
                    or x in ('__str__', '__repr__')
                    )

        @staticmethod
        def _genProp(x):
            fget = lambda self: getattr(self.slave, x)
            fset = lambda self, value: setattr(self.slave, x, value)
            fdel = lambda self: delattr(self.slave, x)
            fdoc = getattr(IRemoteObject, x, None).__doc__
            return property(fget, fset, fdel, fdoc)

    def __init__(self, slave=None):
        if slave is None:
            slave = IRemoteObject()
        self.slave = slave
