# -*- coding: utf-8 -*-
from library.tasks.remote_object_wrapper import RemoteObjectWrapper


class SmoothTask(RemoteObjectWrapper):
    """
    Сгладить нагрузку на кластер от запуска задачи.
    Чтобы задача не начала выполняться одновременно
    на всём кластере, можно выполнить её со случайной задержкой.
    Перед запуском задачи на каждой машине будет выполнена
    случайная задержка длиной от ``0`` до ``tout`` секунд,
    и только после этого будет выполнена сама задача.

    :param slave: задача для выполнения
    :param int tout: максимальное время задержки
    """
    def __init__(self, slave, tout):
        super(SmoothTask, self).__init__(slave)
        self.__tout = tout

    def run(self):
        import time
        time.sleep(self.genTout())
        return self.slave.run()

    def genTout(self):
        import random
        return random.random() * self.__tout

    __call__ = run
