import six


if six.PY3:
    long = int


def runcmd(cmd):
    from subprocess import Popen, PIPE

    return Popen(cmd, shell=True, stdout=PIPE).communicate()[0][:-1]


class SysInfo(object):
    def tmpFreeSpace(self):
        return 1024 * long(runcmd("df -k /var/tmp | tail -n 1 | awk '{print $4}'"))

    def loadAvg(self):
        import os

        return os.getloadavg()[0]

    def freeSpace(self):
        import os
        totalFlag = '-c' if os.uname()[0].lower() == 'freebsd' else '--total'
        cmd = "df -k {0}".format(totalFlag) + " 2>/dev/null | tail -n 1 | awk '{print $4}'"
        return 1024 * long(runcmd(cmd))

    def usedSpace(self):
        return 0

    def sockets(self):
        return long(runcmd('sockstat | wc -l'))

    def idle(self):
        try:
            import pkg_resources
            pkg_resources.require('psutil')
            import psutil

            return 100 - psutil.cpu_percent(interval=1)
        except ImportError:
            def cpu_times():
                return map(long, runcmd('sysctl kern.cp_time').split(' ')[1:])

            import time

            t1 = cpu_times()
            time.sleep(1)
            t2 = cpu_times()

            full = sum(t2) - sum(t1)
            idle = t2[-1] - t1[-1]

            return 100.0 * (idle + 0.01) / (full + 0.01)

    def pageFaults(self):
        return long(runcmd("vmstat | tail -n 1 | awk '{print $6}'"))

    def nCpu(self):
        """
        :return: Number of CPU on current machine
        """
        from kernel.util.sys.ncpu import nCpu
        return nCpu()

    def normalizedLoadAvg(self):
        """
        :return: Normalized load average
        """
        nCpu = self.nCpu()
        if nCpu > 0:
            return self.loadAvg() / nCpu
        else:
            return self.loadAvg()
