# -*- coding: utf-8 -*-
import api.copier


class UploadRunner:
    """
    Загрузить торрент на удалённый сервер.

    :param str resid: id торрента
    :param str tgtPath: каталог, в который необходимо скачать торрент
    :param bool userMode: сохранено для обратной совместимости, не используется
    :param str network: используемая сеть (auto, backbone, fastbone), по умолчанию используются настройки машины
    """
    def __init__(self, resid, tgtPath, userMode=None, network=None):
        self.resid = resid
        self.tgtPath = tgtPath
        self.network = network

    def run(self):
        network = self.network
        if network is not None:
            network = network.lower().capitalize()
            network = {
                'Auto': api.copier.Network.Auto,
                'Backbone': api.copier.Network.Backbone,
                'Fastbone': api.copier.Network.Fastbone,
            }.get(network)
            if network is None:
                raise ValueError("Unknown network mode: %s" % (network,))
        api.copier.Copier().handle(self.resid).get(dest=self.tgtPath, user=True, network=network).wait()
