# -*- coding: utf-8 -*-
from library.tasks.remote_object_wrapper import RemoteObjectWrapper


class UserTask(RemoteObjectWrapper):
    """
    Выполнить дочернюю задачу от заданного пользователя.

    :param slave: задача для исполнения
    :param str user: пользователь, от имени которого задача должна быть исполнена
    :param bool forwardAgent: если флаг выставлен, на удалённую сторону будет
                              проброшен SSH-агент с локальной машины
    """
    def __init__(self, slave, user, forwardAgent=False):
        super(UserTask, self).__init__(slave)
        self.__osUser = user
        self.__forwardSshAgent = forwardAgent

    @property
    def osUser(self):
        return self.__osUser

    @property
    def forwardSshAgent(self):
        return self.__forwardSshAgent
