import pytest

from library.sky.hostresolver import Resolver


def test_nonexistent_host():
    resolver = Resolver(check_hosts=True)
    with pytest.raises(Exception):
        resolver.resolveHosts('h@nonexistent.zone.kokoko')

    resolver = Resolver(check_hosts=False)
    assert resolver.resolveHosts('h@nonexistent.zone.kokoko') == {'nonexistent.zone.kokoko'}
