PYTHONMAJORVERSION="2.7"
PYTHONMINORVERSION="18"

# Detect count of cpu on this machine. FreeBSD & Linux compatible ways
if [ -e /proc/cpuinfo ]; then
    CPUCOUNT=$(grep processor /proc/cpuinfo | wc -l)
elif which sysctl >/dev/null && [ -x $(which sysctl) ]; then
    CPUCOUNT=$(sysctl hw.ncpu | sed 's/hw.ncpu: //')
else
    CPUCOUNT=4
fi

PYTHONVERSION="${PYTHONMAJORVERSION}.${PYTHONMINORVERSION}"

CWD=$(pwd)
ROOT=$(dirname $0)

cd ${ROOT}
ROOT=$(pwd)

#WORKDIR=`mktemp -d "$ROOT/build/XXXXXX"`
WORKDIR=${ROOT}/build
DLDIR=${ROOT}/.downloads
CCACHE_DIR=${ROOT}/.ccache

# Future directories
SKYDIR=${WORKDIR}/skynet
PREFIX=${SKYDIR}/python
LIBDIR=${PREFIX}/lib
INCDIR=${PREFIX}/include
BINDIR=${PREFIX}/bin

if [ "$(uname)" = Darwin ]; then
    SOEXT="dylib"
    PATH="$PATH:/opt/local/bin"
else
    SOEXT="so"
fi

case $(uname) in
    Linux)
        case $(uname -p) in
            aarch64)
                CONFIGURE_BUILD="--build=arm-linux64"
                ;;
            *)
                CONFIGURE_BUILD=""
                ;;
        esac
        ;;
    *)
        CONFIGURE_BUILD=""
        ;;
esac

export LD_LIBRARY_PATH=
export LD_RUN_PATH="${LIBDIR}"
if [ ${#LD_RUN_PATH} -lt 256 ]; then
    LD_RUN_PATH="$LD_RUN_PATH:"
fi

while [ ${#LD_RUN_PATH} -lt 255 ]; do
    LD_RUN_PATH="$LD_RUN_PATH:"
done

if [ "$(uname)" = "Linux" ] || [ "$(uname)" = "FreeBSD" ]; then
    export LDFLAGS="-L${LIBDIR} -Wl,-zorigin"
else
    export LDFLAGS="-L${LIBDIR}"
fi
export CFLAGS="-I${INCDIR} -O2 -fomit-frame-pointer -pipe"
#export CFLAGS="-I${INCDIR} -O2 -ggdb -pipe -DDEBUG"
export CXXFLAGS="${CFLAGS}"
export PYTHONNOUSERSITE=1
export CCACHE_DIR

# required for buildsystem to use certs from build dir even on platforms
# where no certs available yet
export SSL_CERT_DIR="${PREFIX}/etc/ssl/certs"

mkdir -p ${WORKDIR}

export SED=sed

$(which md5sum >/dev/null) && MD5SUM="md5sum" || MD5SUM="md5 -r"
$(which wget >/dev/null) && DLPROG="wget -q --no-check-certificate -O" || DLPROG="fetch -q -p -o"

# Some staff, e.g. IPython, requires "valid" $HOME..
[ -z "${HOME}" ] && export HOME=${WORKDIR} || true
