check_md5() {
    local path="$1"
    local checksum="$2"
    local fpath="$DLDIR/$path"

    echo -n " MD5..."

    [[ -z $checksum ]] && { echo " MISSING!"; return; }

    if [[ ! -e $fpath ]]; then
        echo " FAIL"
        push
        info "md5 check failed because file was not found at $fpath"
        pop
        return 1
    fi

    if [[ ! $($MD5SUM $fpath | cut -c -32) = "$checksum" ]]; then
        echo " FAIL"
        push
        info "md5 check failed because checksum mismatch"
        pop
        rm -f "$fpath"
        return 1
    else
        echo " OK"
        return 0
    fi
}

dl_meth() {
    local method=$1
    local uri=$2
    local target=$3
    local checksum=$4

    info_d "downloading to $target from $method:$uri"
    push

    mkdir -p "$DLDIR"

    case $method in
        rbtorrent)
            if [ -z "$(command -v sky)" ];
            then
                push
                info 'No `sky´ available'
                pop
                return 1
            fi
            sky get -d "$DLDIR" -u -w "$method:$uri" 2> "$DLDIR/.plog"
            ;;
        ftp|http*)
            $DLPROG "$DLDIR/$target" "$method:$uri" 2> "$DLDIR/.plog"
            ;;
        *)
            info "Unknown method $method"
            exit 1
            ;;
    esac

    local plog=$(cat $DLDIR/.plog)
    if [[ ! -z $plog ]]; then
        info_d "$plog"
    fi

    local ecode=$?
    if [[ ! -z $checksum ]]; then
        info_c NONL "rechecking..."
        check_md5 $target $checksum
        ecode=$?
        pop
        return $ecode
    fi

    pop
    return $ecode
}

dl() {
    set +e

    local target
    local md5checksum=""

    declare -a uris

    for arg in "$@"; do
        if [[ ${arg%:*} = "md5" ]]; then
            md5checksum=${arg#*:}
        elif [[ ${arg%:*} = "fn" ]]; then
            target=${arg#*:}
        else
            uris[${#uris[@]}]="$arg"
        fi
    done

    info_c NONL "$target..."
    check_md5 $target $md5checksum && return

    push

    set -- "${uris[@]}"

    for arg in "$@"; do
        scheme=${arg%:*}
        if [[ -z "$scheme" ]]; then
            info "Ignoring scheme $scheme"
            continue
        fi
        uri=${arg#*:}

        case $scheme in
            rbtorrent|ftp|http*)
                shift
                if dl_meth "$scheme" "$uri" "$target" "$md5checksum"; then
                    pop
                    return
                fi
                ;;
            md5|pypi)
                shift
                ;;
            *)
                echo "UNKNOWN $scheme"
                exit 1
                ;;
        esac
    done

    info_d "failed to download"
    pop
    exit 1
    set -e
}
