run() {
    info "Running $*"
    set +e
    "$@" >${WORKDIR}/.runlog 2>&1
    code=$?
    if [ ! ${code} -eq 0 ]; then
        echo "ERROR: Command failed with status code ${code}:"
        echo
        echo "..."
        tail -n 10 ${WORKDIR}/.runlog
        echo
        echo
        echo "Full log located at .runlog file"
        exit ${code}
    else
        [ -e ${WORKDIR}/.runlog ] && /bin/rm ${WORKDIR}/.runlog
    fi
    set -e
}
