findgcc() {
    case $(uname) in
        Linux)
            case $(uname -p) in
                aarch64)
                    CC=gcc-4.7
                    CXX=g++-4.7
                    ;;
                *)
                    CC=gcc-4.8
                    CXX=g++-4.8
                    ;;
            esac
            ;;
        FreeBSD)
            CC=gcc44
            CXX=g++44
            ;;
        Darwin)
            CC=clang
            CXX=clang++
            ;;
        CYGWIN*)
            CC=gcc
            CXX=g++
            ;;
        *)
            echo "Could not find suitable GCC version for $(uname) platform"
            exit 1
    esac

    if ! command -v "$CC" >/dev/null 2>&1; then
        echo "error: no $CC"
        return 1
    fi
    if ! command -v "$CXX" >/dev/null 2>&1; then
        echo "error: no $CXX"
        return 1
    fi

    export CC
    export CXX
}

