__MD5_CHECK__() {
    local __MD5__=
    local __MD5_PROG__=
    local __COMPUTED_MD5__=

    __MD5_PROG__="$(which md5 2>&1)" || __MD5_PROG__="$(which md5sum 2>&1)"

    [ ! -x "${__MD5_PROG__}" ] && echo "WARNING: md5/md5sum not found! Skipped MD5 checking..." >&2 && return

    [ "${__MD5_PROG__}" = "md5" ] && __MD5_PROG__="${__MD5_PROG__} -r"

    __COMPUTED_MD5__=$(tail -n +$(awk '/^    local __MD5__=/ { print NR+1; exit 0; }' "$1") "$1" | ${__MD5_PROG__} | cut -c -32)

    if [ "$2" = "NEW" ]; then
        echo ${__COMPUTED_MD5__}
        return
    fi

    if [ ! "${__COMPUTED_MD5__}" = "${__MD5__}" ]; then
        echo "Error: $(basename "$0") file has been corrupted! :-(. MD5 sums: stored ${__MD5__}; got ${__COMPUTED_MD5__}" >&2
        exit 17
    fi
}

if [ "$(basename "$0")" = "md5checker.sh" ]; then
    MD5=$(__MD5_CHECK__ "$1" NEW)
    if [ "$(uname)" = "Darwin" ]; then
        SED=gsed
    elif [[ "$(uname)" = "CYGWIN"* ]]; then
        SED='sed -b'
    else
        SED=sed
    fi
    $SED -i -e "s/^    local __MD5__=.*/    local __MD5__=${MD5}/" "$1"
    exit 0
fi

