from __future__ import print_function

import os
import sys
import subprocess as subproc
import socket

from itertools import chain


def run(*args):
    args = [str(arg) for arg in args]
    print('>>> running %s' % (subproc.list2cmdline(args), ))
    proc = subproc.Popen(args)
    proc.wait()
    if proc.returncode != 0:
        print('ERR Process exited with exit code %d' % (proc.returncode, ), file=sys.stderr)
        raise SystemExit(proc.returncode)


def clean(path):
    if path.check(exists=1):
        if path.check(dir=1):
            for cpath, dirs, files in os.walk(path.strpath):
                for item in chain([cpath], dirs, files):
                    try:
                        py.path.local(item).chmod(0777)
                    except (py.error.EACCES, py.error.ENOENT):
                        pass

        path.remove(ignore_errors=True)


def getarch():
    name = os.uname()[0].lower()
    arch = 'x86' if sys.maxint == 2**31 - 1 else 'amd64'

    if name == 'linux':
        lsb = py.path.local('/etc/lsb-release')
        if not lsb.check(exists=1):
            return 'linux_' + arch
        else:
            lsbdict = {}
            for line in lsb.open('r'):
                if '=' not in line:
                    continue
                key, value = line.split('=', 1)
                lsbdict[key.strip()] = value.strip()

            name = lsbdict.get('DISTRIB_ID', 'linux').strip().lower()
            release = lsbdict.get('DISTRIB_RELEASE', '').split('.', 1)[0].strip()

            return name + release + '_' + arch
    elif name == 'freebsd':
        return name + os.uname()[2][0] + '_' + arch
    else:
        return 'unknown_' + arch

if __name__ == '__main__':
    import py
    tmpdir = None

    this = py.path.local(sys.argv[0])

    for idx, arg in enumerate(sys.argv):
        if arg == '-T':
            tmpdir = py.path.local(sys.argv[idx + 1])
            break

    if tmpdir is None:
        print('Cant find tempdir!!', file=sys.stderr)
        raise SystemExit(1)

    pwd = py.path.local()
    os.chdir(tmpdir.strpath)

    clean(tmpdir.join('selftest'))

    virtualenv = py.path.local(sys.executable).dirpath().join('virtualenv')
    venv = tmpdir.join('venv')
    python = venv.join('bin', 'python')

    run(sys.executable, virtualenv.strpath, '--system-site-packages', venv)
    run(python, '--version')
    run(
        venv.join('bin', 'pip'),
        'install',
        '--index', 'http://pypi.yandex-team.ru/simple',
        'py==1.4.18',
        'pytest==2.4.2',
        'teamcity-messages==1.7',
        'execnet==1.1',
        'pytest-xdist==1.9'
    )

    pytest_opts = [
        '--tb=short', '-v',
        '--basetemp', tmpdir.join('selftest'),
    ]

    if pwd.join('tests', 'teamcity').check(dir=1, exists=1):
        run(
            venv.join('bin', 'pip'),
            'install', pwd.join('tests', 'teamcity')
        )
        pytest_opts += [
            '--teamcity-ex',
            '--teamcity-flow-prefix', socket.gethostname(),
            '--teamcity-global-suite', getarch(),
        ]

    open('data.tar', 'wb').write(sys.stdin.read())

    run(
        *(
            [venv.join('bin', 'py.test')] +
            pytest_opts +
            [this.dirpath().join('tests')]
        )
    )

    clean(tmpdir)  # cleanup whole tmpdir if test was successful

    raise SystemExit(0)
