import textwrap


def testVersion(a, b, comp):
    from skyinstall import Version as V

    assert comp in ('<', '>', '=='), 'Unknown comparison!'
    if comp == '<':
        comp = '>'
        a, b = b, a

    if comp == '>':
        assert V(a) > V(b)
        assert V(b) < V(a)

    elif comp == '==':
        assert V(a) == V(b)


def pytest_generate_tests(metafunc):
    for line in textwrap.dedent('''
        1 < 2
        a < b
        1 == 1
        1.0 == 1
        1.0.0.0 == 1
        1a2 == 1.a.2
        1.0.1 > 1.0
        1.0a > 1a       # corner case: 1.0a != 1a, because 1.0.1 != 1.1
        2 > 1
        1.99+ < 2.0
        text < 0        # any garbage should be lower than real versions
        1.2.3 == 1.2.3.0
        1.2.3 < 1.2.3.1
        1.2.4 > 1.2.3.1
        1.2a == 1.2a
        1.2a < 1.2b
        1.2a < 1.3
        1.2a < 1.2
        1.2.a == 1.2.a
        1.2.a < 1.2.b
        1.2.a < 1.3
        1.2.a < 1.2
        1.2.a < 1.3a
        1.2.a == 1.2a
    ''').strip().split('\n'):
        a, comp, b = line.split()[:3]
        metafunc.addcall(
            funcargs={'a': a, 'b': b, 'comp': comp},
            id='%s %s %s' % (a, comp, b)
        )
