N=chrpath
FN=${N}-0.13.tar.gz
FNR=${FN%.tar.gz}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:b73072a8fbba277558c50364b65bb407
    rbtorrent:03e2c04154dd93f3b02a06cd64cc083b2de2cac9
    http://ftp.tux.org/pub/X-Windows/ftp.hungry.com/$N/$FN
"

build() {
    info "Building chrpath"
    push
    if [ "$(uname)" = "Darwin" ] || [[ "$(uname)" = "CYGWIN"* ]]; then
        info "disabled on $(uname)"
        pop
        return
    fi

    run tar -xzf "${DLDIR}/${FN}" -C "${WORKDIR}"
    cd "${WORKDIR}/${FNR}"

    run ./configure $CONFIGURE_BUILD --prefix="${PREFIX}"
    make
    make install

    ./chrpath -r '$ORIGIN/../lib' "${PREFIX}/bin/chrpath"

    pop
    info "Build OK"
}
