N=ccache
FN=$N-3.1.9.tar.bz2
FNR=${FN%.tar.bz2}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:65f48376a91d3651d6527ca568858be8
    rbtorrent:e946e647cbff6e3ab357fd15b940384c54b164f2
    http://samba.org/ftp/$N/$FN
"

build() {
    info "Building ccache"
    push
    if [[ "$(uname)" = "CYGWIN"* ]] || [[ "$(uname -sp)" = "Darwin arm" ]]; then
        info "disabled on $(uname)"
        pop
        return
    fi

    run tar -xjf "${DLDIR}/${FN}" -C "${WORKDIR}"
    cd "${WORKDIR}/${FNR}"

    run ./configure --prefix="${PREFIX}"
    make
    make install

    mkdir -p "${BINDIR}"
    NCC="${BINDIR}/$(basename "$CC")"
    NCXX="${BINDIR}/$(basename "$CXX")"

    run ln -sf "${BINDIR}/ccache" "${NCC}"
    run ln -sf "${BINDIR}/ccache" "${NCXX}"

    export CC="$NCC"
    export CXX="$NCXX"

    pop
    info "Build OK"
}
