FN=libjpeg-turbo-1.2.1.tar.gz
FNR=${FN%.tar.gz}
DLS[${#DLS[@]}]="
    fn:$FN
    md5:f61e60ff01381ece4d2fe65eeb52669e
    rbtorrent:b18b64b710c0778c751696fb5f49006d01eb05b2
    http://downloads.sourceforge.net/project/libjpeg-turbo/1.2.1/$FN
"

build() {
    info "Building libjpeg-turbo"
    push

    run tar -xzf "${DLDIR}/${FN}" -C "${WORKDIR}"
    cd "${WORKDIR}/${FNR}"
    if [[ "$(uname)" = "CYGWIN"* ]]; then
	    cp /usr/share/automake-1.15/config.guess .
	fi
    if [ "$(uname)" = "Darwin" ]; then
        run autoreconf -fiv
    fi
    run bash ./configure $CONFIGURE_BUILD --prefix="${PREFIX}" --with-jpeg8 --without-java --without-simd --with-pic
    make
    make -j1 install

    pop
    info "Build OK"
}
