FN=bzip2-1.0.6.tar.gz
FNR=${FN%.tar.gz}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:00b516f4704d4a7cb50a1d97e6e8e15b
    rbtorrent:32c99a614974227dc2042869a40e4573429a17d7
    http://www.bzip.org/1.0.6/${FN}
"

build() {
    info "Building libbz2"
    push

    run tar -xzf "${DLDIR}/${FN}" -C "${WORKDIR}"
    cd "${WORKDIR}/${FNR}"

    if [ "$(uname)" = Darwin ]; then
        sed -e 's/-Wl,-soname//' -e 's/-Wl,libbz2.so.1.0//' -e 's/bz2.so/bz2.dylib/g' Makefile-libbz2_so > Makefile-libbz2_dylib
        mv Makefile-libbz2_dylib Makefile-libbz2_so
    fi

    make -f Makefile-libbz2_so
    make

    make -j1 install PREFIX="${PREFIX}"

    if [ "$(uname)" = "Darwin" ]; then
        cp -af libbz2.dylib* "${LIBDIR}"
    else
        cp -af libbz2.so* "${LIBDIR}"
    fi

    pop
    info "Build OK"
}
