# use latest version of ncurses, cuz this version can be built in cygwin64 using GCC 5.3
FN=ncurses-6.0.tar.gz
FNR=${FN%.tar.gz}

# FIXME: use new proper torrent id
DLS[${#DLS[@]}]="
    fn:$FN
    md5:ee13d052e1ead260d7c28071f46eefb1
    rbtorrent:f5dae6b3d4b58f740471d633d297ad3011ed7155
    http://ftp.gnu.org/gnu/ncurses/$FN
"

build() {
    info "Building ncurses"
    push

    run tar -xzf "${DLDIR}/${FN}" -C "${WORKDIR}"
    cd "${WORKDIR}/${FNR}"

    LDFLAGS_DIRTY="${LDFLAGS}"
    LDFLAGS=""
    CFLAGS_DIRTY="${CFLAGS}"

    for flag in ${LDFLAGS_DIRTY}; do
        if [ "${flag:0:4}" = "-Wl," ]; then
            CFLAGS="$CFLAGS $flag"
        else
            LDFLAGS="${LDFLAGS} ${flag}"
        fi
    done

    export LDFLAGS
    export CFLAGS

    if [ "$(uname)" = Darwin ]; then
        sed -e 's/-no-cpp-precomp//' configure > configure.tmp
        mv configure.tmp configure
        chmod +x configure
    fi

    run ./configure $CONFIGURE_BUILD \
                    --prefix="${PREFIX}" \
                    --with-default-terminfo-dir=/usr/share/terminfo \
                    --with-shared \
                    --without-gpm \
                    --without-hashed-db \
                    --disable-termcap \
                    --enable-const \
                    --enable-colorfgbg \
                    --enable-echo \
                    --disable-sp-funcs \
                    --enable-sigwinch \
                    --enable-widec \
                    --enable-ext-colors \
                    --without-xterm-new

    make
    make -j1 install

    for f in $(ls "$INCDIR/ncursesw"); do
        ln -snf "ncursesw/$f" "$INCDIR/$f"
    done

    export LDFLAGS="${LDFLAGS_DIRTY}"
    export CFLAGS="${CFLAGS_DIRTY}"

    pop
    info "Build OK"
}
