FN=libxml2-2.9.2.tar.gz
FNR=${FN%.tar.gz}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:9e6a9aca9d155737868b3dc5fd82f788
    rbtorrent:e5beb1b11ef178c8aae42676abd5db20b428e563
    ftp://xmlsoft.org/libxml2/$FN
"

build() {
    info "Building libxml2"
    push

    run tar -xzf ${DLDIR}/${FN} -C ${WORKDIR}
    cd ${WORKDIR}/${FNR}

    run ./configure $CONFIGURE_BUILD \
                    --prefix="${PREFIX}" \
                    --enable-ipv6=yes \
                    --enable-rebuild-docs=no \
                    --enable-shared \
                    --enable-static \
                    --with-html \
                    --with-legacy \
                    --with-pic \
                    --with-readline \
                    --with-zlib \
                    --with-iconv \
                    --without-ftp \
                    --without-http \
                    --without-icu \
                    --without-lzma \
                    --without-python

    make
    make -j1 install

    pop
    info "Build OK"
}
