FN=libxslt-1.1.28.tar.gz
FNR=${FN%.tar.gz}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:9667bf6f9310b957254fdcf6596600b7
    rbtorrent:867d1acc1cdf9b38f8e96115940a4bca74ccf79b
    ftp://xmlsoft.org/libxml2/$FN
"

build() {
    info "Building libxslt"
    push

    run tar -xzf "${DLDIR}/${FN}" -C "${WORKDIR}"
    cd "${WORKDIR}/${FNR}"

    run ./configure $CONFIGURE_BUILD \
                    --prefix="${PREFIX}" \
                    --with-libxml-prefix="${PREFIX}" \
                    --enable-shared \
                    --enable-static \
                    --with-pic \
                    --without-python \
                    --without-crypto

    make
    make -j1 install

    pop
    info "Build OK"
}
