FN=unzip60.tar.gz
FNR=${FN%.tar.gz}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:62b490407489521db863b523a7f86375
    rbtorrent:15240a9a25284652bba5ec2085fb5fe1d9dca1ca
    http://downloads.sourceforge.net/project/infozip/UnZip%206.x%20(latest)/UnZip%206.0/$FN
"

build() {
    info "Building unzip (info-zip)"
    push

    run tar -xzf "${DLDIR}/${FN}" -C "${WORKDIR}"
    cd "${WORKDIR}/${FNR}"

    info "Patching unix/Makefile"
    ${SED} -i -e '/^CFLAGS/d' unix/Makefile
    ${SED} -i -e '/CFLAGS/s:-O[0-9]\?:$(CFLAGS) $(CPPFLAGS):' unix/Makefile
    ${SED} -i -e '/^STRIP/s:=.*:=true:' unix/Makefile
    ${SED} -i -e "s:\<CC=gcc\>:CC=\"${CC}\":" unix/Makefile
    ${SED} -i -e "s:\<LD=gcc\>:LD=\"${CC}\":" unix/Makefile
    ${SED} -i -e "s:\<AS=gcc\>:AS=\"${CC}\":" unix/Makefile
    ${SED} -i -e 's:LF2 = -s:LF2 = :' unix/Makefile
    ${SED} -i -e 's:LF = :LF = $(LDFLAGS) :' unix/Makefile
    ${SED} -i -e 's:SL = :SL = $(LDFLAGS) :' unix/Makefile
    ${SED} -i -e 's:FL = :FL = $(LDFLAGS) :' unix/Makefile
    if [[ "$(uname)" = "CYGWIN"* ]]; then
        #FIXME later cuz it breaks any asm dependent build
        ${SED} -i -e 's:-DASM_CRC::' unix/Makefile
        ${SED} -i -e 's:CRCA_O=crc_gcc$O::' unix/Makefile
    fi

    #${SED} -i -e "/^#L_BZ2/s:::" unix/Makefile

    local TARGET
    case $(uname -sm) in
        "FreeBSD amd64")    TARGET=bsd ;;
        "FreeBSD i"?86)     TARGET=freebsd ;;
        "Linux amd64" | \
        "Linux x86_64" | \
        "Linux aarch64")    TARGET=linux_noasm ;;
        "Linux i"?86)       TARGET=linux_asm ;;
        "Darwin x86_64")    TARGET=bsd ;;
        "Darwin arm64")     TARGET=bsd ;;
        "CYGWIN"*)          TARGET=cygwin ;;
        *) info "Cant determine target (source $(uname -sm))"; exit 1 ;;
    esac

    make -f unix/Makefile ${TARGET}

    info "Installing unzip"
    mkdir -p "${BINDIR}"
    cp -f unzip "${BINDIR}"

    pop
    info "Build OK"
}
