FN="openssl-1.1.1k.tar.gz"
FNR=${FN%.tar.gz}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:c4e7d95f782b08116afa27b30393dd27
    rbtorrent:099420101866444156fc4a05a5484683e24d0694
    http://www.openssl.org/source/$FN
"

build() {
    info "Building openssl"
    push

    run tar -xzf "${DLDIR}/${FN}" -C "${WORKDIR}"

    cd "${WORKDIR}/${FNR}"

    local CONFIG_OPTIONS="--prefix=/skynet/python --openssldir=etc/ssl --libdir=lib shared threads"
    if [ "$(uname)" = "Darwin" ]; then
        # Darwin requires to rerun Configure for matching platform
        if [ "$(uname -p)" = "arm" ]; then
            CONFIG_OPTIONS="${CONFIG_OPTIONS} darwin64-arm64-cc"
        else
            CONFIG_OPTIONS="${CONFIG_OPTIONS} darwin64-x86_64-cc"
        fi
        run ./Configure ${CONFIG_OPTIONS}
    elif [[ "$(uname)" = "CYGWIN"* ]]; then
        CONFIG_OPTIONS="${CONFIG_OPTIONS} Cygwin-x86_64 no-asm"
        run ./Configure ${CONFIG_OPTIONS}
    else
        run ./config ${CONFIG_OPTIONS}
    fi

    # Clean out hardcoded flags that openssl uses
    local CFLAG=$(grep ^CFLAG= Makefile | LC_ALL=C ${SED} \
        -e 's:^CFLAG=::' \
        -e 's:-fomit-frame-pointer ::g' \
        -e 's:-O[0-9] ::g' \
        -e 's:-march=[-a-z0-9]* ::g' \
        -e 's:-mcpu=[-a-z0-9]* ::g' \
        -e 's:-m[a-z0-9]* ::g' \
    )
    local SHARED_LDFLAGS=$(grep ^SHARED_LDFLAGS= Makefile | ${SED} \
        -e 's:^SHARED_LDFLAGS=::'\
    )

    ${SED} -i -e "/^CFLAG/s:=.*:=${CFLAG} ${CFLAGS}:" Makefile
    ${SED} -i -e "/^SHARED_LDFLAGS/s:=.*:=${SHARED_LDFLAGS} ${LDFLAGS}:" Makefile

    make -j0 all # rehash

    make -j0 DESTDIR=${WORKDIR} install_sw install_ssldirs

    pop
    info "Build OK"
}
