FN=Python-${PYTHONMAJORVERSION}.${PYTHONMINORVERSION}.tgz
FNR=${FN%.tgz}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:38c84292658ed4456157195f1c9bcbe1
    rbtorrent:b4abc18fcd8bc6892842c754dc8e057b9391852f
    http://www.python.org/ftp/python/${PYTHONMAJORVERSION}.${PYTHONMINORVERSION}/$FN
"

build() {
    info "Building python"
    push

    rm -rf "${WORKDIR}/Python-${PYTHONMAJORVERSION}.${PYTHONMINORVERSION}"
    run tar -xzf "${DLDIR}/${FN}" -C "${WORKDIR}"

    cd "${WORKDIR}/${FNR}"

    for ptch in $(find "${ROOT}/libraries/" -name "${FNR}_*.patch" | sort); do
        run patch -p0 -N -i "${ptch}"
    done

    ${SED} -i -e \
        "s:inc_dirs = self.compiler.include_dirs + :inc_dirs = self.compiler.include_dirs + ['${INCDIR}'] + :" setup.py

    if [ ! "$(uname)" = "Darwin" ] && [[ ! "$(uname)" = "CYGWIN"* ]]; then
        LDFLAGS="${LDFLAGS} -Wl,-R${LD_RUN_PATH}"
    fi

    if [ "$(uname)" = Darwin ] && [ "$(uname -p)" != "arm" ]; then
        NCC="${BINDIR}/clang"
        NCXX="${BINDIR}/clang++"

        run ln -sf "${BINDIR}/ccache" "${NCC}"
        run ln -sf "${BINDIR}/ccache" "${NCXX}"

        OCC=$CC
        OCXX=$CXX
        export CC="$NCC"
        export CXX="$NCXX"
    fi

    if [[ "$(uname)" = "CYGWIN"* ]]; then
        LDFLAGS="${LDFLAGS} -L$(pwd)" run bash ./configure --prefix="" --enable-shared --enable-ipv6 --with-pymalloc --with-cxx-main --enable-unicode=ucs2
    elif [ "$(uname -sp)" = "Darwin arm" ]; then
        LDFLAGS="${LDFLAGS} -L$(pwd)" run bash ./configure --prefix="" --enable-shared --enable-ipv6 --with-pymalloc --with-fpectl --with-cxx-main --enable-unicode=ucs2 --with-system-ffi
    else
        LDFLAGS="${LDFLAGS} -L$(pwd)" run bash ./configure --prefix="" --enable-shared --enable-ipv6 --with-pymalloc --with-fpectl --with-cxx-main --enable-unicode=ucs2
    fi

    # Hack with DESTPATH will automatically add /skynet to pythonpath
    # if python located at /skynet/python
    make DESTPATH=:../../..
    make -j1 install DESTDIR=${PREFIX}

    if [ "$(uname)" = Darwin ] && [ "$(uname -p)" != "arm" ]; then
        export CC=$OCC
        export CXX=$OCXX
    fi

    # Add python-gdb
    mkdir -p "$PREFIX/lib/gdb"
    if [ "$(uname)" = "Darwin" ] || [[ "$(uname)" = "CYGWIN"* ]]; then
        cp python.exe-gdb.py "$PREFIX/lib/gdb/libpython2.7.py"
    else
        cp python-gdb.py "$PREFIX/lib/gdb/libpython27.py"
    fi

    if [ "$(uname)" = "Darwin" ]; then
        info "Renaming library on Darwin"
        chmod u+w "$BINDIR/python2.7"
        chmod u+w "$LIBDIR/libpython2.7.dylib"
        install_name_tool -id skynet/libpython2.7.dylib "$LIBDIR/libpython2.7.dylib"
        install_name_tool -change skynet/libpython2.7.dylib @loader_path/../lib/libpython2.7.dylib "$BINDIR/python2.7"
        install_name_tool -change /lib/libpython2.7.dylib @loader_path/../lib/libpython2.7.dylib "$BINDIR/python2.7"
    fi

    # Fix _sysconfigdata.py
    info "Fixing _sysconfigdata.py"
    push

    cd "$PREFIX/lib/python2.7"

    local conffile=_sysconfigdata.py

    if ( ! grep skynet_aware "$conffile"  >/dev/null 2>&1 ); then
        info "Fixing _sysconfigdata.py..."
        cat >> "$conffile" << PYEND

import sys
import os


skynet_aware = True
skynet_root = os.path.dirname(os.path.dirname(sys.executable))
skynet_lib = os.path.join(skynet_root, 'lib')
skynet_include = os.path.join(skynet_root, 'include')


def _replace_include(s):
    items = s.split()
    for idx, item in enumerate(items):
        if item.startswith('-I'):
            include = item[2:]
            if include.startswith('/'):
                items[idx] = ''
    items.append('-I' + skynet_include)
    return ' '.join(_ for _ in items if _)


def _fix_ldflags(s):
    items = s.split()
    for idx, item in enumerate(items):
        if item.startswith('-L'):
            items[idx] = ''
    items.insert(0, '-L' + skynet_lib)
    return ' '.join(_ for _ in items if _)


# Main build staff
envcc = os.getenv('CC', 'gcc')
envcxx = os.getenv('CXX', 'g++')

build_cc = build_time_vars.get('CC', 'gcc')
if build_cc.count(' '):
    build_cc_flags = ' ' + build_cc.split(None, 1)[1]
else:
    build_cc_flags = ''

build_cxx = build_time_vars.get('CXX', 'g++')
if build_cxx.count(' '):
    build_cxx_flags = ' ' + build_cxx.split(None, 1)[1]
else:
    build_cxx_flags = ''

build_time_vars['CC'] = envcc + build_cc_flags
build_time_vars['CXX'] = envcxx + build_cxx_flags

build_time_vars['LDFLAGS'] = ' '.join((os.getenv('LDFLAGS', ''), _fix_ldflags(build_time_vars['LDFLAGS'])))

# Aliases
build_time_vars['MAINCC'] = build_time_vars['LINKCC'] = build_time_vars['CC']

# Shared build staff
if '-lpython2.7' not in build_time_vars['LDFLAGS']:
    build_time_vars['LDFLAGS'] += ' -lpython2.7'

build_time_vars['LDSHARED'] = build_time_vars['BLDSHARED'] = build_time_vars['LDCXXSHARED'] = (
    '%s -shared %s' % (build_time_vars['CC'], build_time_vars['LDFLAGS'])
)
build_time_vars['LDCXXSHARED'].replace(build_time_vars['CC'], build_time_vars['CXX'])

# Fix cflags
build_time_vars['CFLAGS'] = _replace_include(build_time_vars['CFLAGS'])
build_time_vars['PY_CFLAGS'] = _replace_include(build_time_vars['PY_CFLAGS'])

# Fix runshared and testpython
build_time_vars['RUNSHARED'] = 'LD_LIBRARY_PATH=%s' % (skynet_lib, )
build_time_vars['TESTPYTHON'] = '%s ./python -Wd -3 -E -tt' % (build_time_vars['RUNSHARED'], )
PYEND
    fi

    pop
    info "Done"

    pop
    info "Build OK"
}
