FN=gmp-6.2.1.tar.bz2

DLS[${#DLS[@]}]="
    fn:$FN
    md5:28971fc21cf028042d4897f02fd355ea
    rbtorrent:441a239ae520f2797d0a0bb45bed58c08987d606
    https://gmplib.org/download/gmp/$FN
"

build() {
    info "Building libgmp"
    push

    if [ "$(uname -p)" = "aarch64" ]; then
        pop
        info "Skipped on aarch64"
        return
    fi

    run tar -xjf "${DLDIR}/${FN}" -C "${WORKDIR}"

    cd "${WORKDIR}/gmp-6.2.1"

    _CFLAGS=${CFLAGS}
    unset CFLAGS

    PLATFORM_SPECIFIC=""
    if [ "$(uname -sp)" = "Linux x86_64" ]; then
        PLATFORM_SPECIFIC="--host=sandybridge-pc-linux-gnu"
    fi
    run ./configure $CONFIGURE_BUILD --prefix "${PREFIX}" ${PLATFORM_SPECIFIC}

    make
    make install

    export CFLAGS=${_CFLAGS}
    unset _CFLAGS

    pop
    info "Build OK"
}
