FN="ca-certificates_20210119~20.10.1.tar.gz"
FNR="ca-certificates-20210119~20.10.1"

DLS[${#DLS[@]}]="
    fn:$FN
    md5:6316924201689a44451512d39ea38212
    rbtorrent:f7a2fdbaf5c21f21c62a61898cc9251f137cfcae 
    https://proxy.sandbox.yandex-team.ru/2186126840
"

build() {
    info "Installing CA certificates"
    push

    run tar -xzf "${DLDIR}/${FN}" -C "${WORKDIR}"

    cd "${WORKDIR}/${FNR}"

    for ptch in $(find "${ROOT}/libraries/" -name "ca-certificates_*.patch" | sort); do
        run patch -p0 -N -i "${ptch}"
    done

    ( cd mozilla && run "${PREFIX}/bin/python" certdata2pem.py )
    run cp mozilla/*.crt "$PREFIX/etc/ssl/certs/"
    run cp "$ROOT/build_v2/extra/YandexInternalRootCA.crt" "$PREFIX/etc/ssl/certs/"
    PATH="$PREFIX/bin:$PATH" run sbin/update-ca-certificates -v --fresh --default --certsconf /dev/null --certsdir "$PREFIX/etc/ssl/certs" --localcertsdir /dev/null --certbundle unusedbundle.crt --etccertsdir "$PREFIX/etc/ssl/certs" --hooksdir /dev/null

    pop
    info "Install OK"
}
