FN=protobuf-2.3.0.tar.bz2
FNR=${FN%.tar.bz2}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:f2964f636b3c67d1e9d8b90819fa8ddb
    rbtorrent:b09094528b3f23a5ee15f4d99c14aaba8405874f
    http://protobuf.googlecode.com/files/$FN
"

build() {
    info "Building protobuf"
    push

    run tar -xjf "${DLDIR}/${FN}" -C "${WORKDIR}"

    cd "${WORKDIR}/${FNR}"

    for ptch in $(find "${ROOT}/libraries/" -name "${FNR}_*.patch" | sort); do
        run patch -p0 -N -i "${ptch}"
    done

    run ./configure $CONFIGURE_BUILD --prefix="${PREFIX}" --disable-static

    cd src
    if [[ "$(uname)" = "CYGWIN"* ]]; then
        make protoc.exe
    else
        make protoc
    fi

    make install

    pop
    info "Build OK"
}
