FN=db-4.8.30.tar.gz
FNR=${FN%.tar.gz}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:f80022099c5742cd179343556179aa8c
    rbtorrent:57d7c0edd00916daabb65445ea320ab18ad56860
    http://download.oracle.com/berkeley-db/$FN
"

build() {
    info "Building BerkeleyDB"
    push

    run tar -xzof "${DLDIR}/${FN}" -C "${WORKDIR}"

    cd "${WORKDIR}/${FNR}"

    run chmod -R +w ./*

    for ptch in $(find "${ROOT}/libraries/" -name "${FNR}_*.patch" | sort); do
        run patch -p0 -N -i "${ptch}"
    done

    cd build_unix
    CFLAGS="-Wno-error=implicit-function-declaration" run sh ../dist/configure $CONFIGURE_BUILD --prefix="${PREFIX}"

    CFLAGS="-Wno-error=implicit-function-declaration" make
    make install

    pop
    info "Build OK"
}
