FN=logrotate-3.8.6.tar.gz
FNR=${FN%.tar.gz}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:cd0082bbd7248e627ec659f2442fcdf9
    rbtorrent:78238160543442d7530312c6732ae4c6eb39b212
    https://fedorahosted.org/releases/l/o/logrotate/$FN
"

build() {
    return
    info "Building logrotate"
    push
    if [[ "$(uname)" = "CYGWIN"* ]]; then
        info "disabled on $(uname)"
        pop
        return
    fi

    run tar -xzf "${DLDIR}/${FN}" -C "${WORKDIR}"

    cd "${WORKDIR}/${FNR}"

    for ptch in $(find "${ROOT}/libraries/" -name "${FNR}_*.patch" | sort); do
        run patch -p0 -N -i "${ptch}"
    done

    make LOCALBASE="${PREFIX}" POPT_DIR="${PREFIX}" PREFIX="${PREFIX}"
    make \
        LOCALBASE="${PREFIX}" \
        POPT_DIR="${PREFIX}" \
        PREFIX="${PREFIX}" \
        BSD_INSTALL_PROGRAM="install -s -m 555" \
        BSD_INSTALL_MAN="install -m 444" \
        BINDIR="/bin" \
        MANDIR="/man" \
        install

    pop
    info "Build OK"
}

