VERSION=1.3.0
FN=ecdsa-${VERSION}.tar.gz
FNR=${FN%.tar.gz}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:b5dd3bc7a422df6ffdc4f146d5efe3b8
    rbtorrent:e9f63ca1a542b8d9d2b6a6344b70c36725e22125
    https://github.com/torkve/ecdsa/archive/v${VERSION}.tar.gz
"

build() {
    info "Building pyecdsa"
    push

    if [[ "$(uname)" = "CYGWIN"* ]]; then
        info "disabled on $(uname)"
        pop
        return
    fi

    if [[ "$(uname)" = "CYGWIN"* ]]; then
        export SOEXT='dll'
    fi

    run tar -xzf "${DLDIR}/${FN}" -C "${WORKDIR}"

    cd "${WORKDIR}/${FNR}"

    for ptch in $(find "${ROOT}/libraries/" -name "${FNR}_*.patch" | sort); do
        run patch -p0 -N -i "${ptch}"
    done

    PATH=${BINDIR}:${PATH} run cmake \
        -DOPENSSL_CRYPTO_LIBRARY="${LIBDIR}/libcrypto.${SOEXT}" \
        -DOPENSSL_SSL_LIBRARY="${LIBDIR}/libssl.${SOEXT}" \
        -DOPENSSL_INCLUDE_DIR="${INCDIR}" \
        -D_OPENSSL_VERSION="1.1.1k" \
        -DPYTHON_EXECUTABLE="${BINDIR}/python" \
        -DPYTHON_INCLUDE_DIR="${INCDIR}/python${PYTHONMAJORVERSION}" \
        -DPYTHON_INCLUDE_DIR2="${INCDIR}/python${PYTHONMAJORVERSION}" \
        -DPYTHON_LIBRARY="${LIBDIR}/libpython${PYTHONMAJORVERSION}.${SOEXT}" \
        -DCMAKE_INSTALL_PREFIX="${PREFIX}" \
        -DCMAKE_INSTALL_RPATH="${LD_RUN_PATH}:${LIBDIR}":'$ORIGIN/../..' \
        -DINSTALL_DIR="lib/python${PYTHONMAJORVERSION}/site-packages"
    make
    make install

    pop
    info "Build OK"
}

