FN=yaml-0.1.5.tar.gz
FNR=${FN%.tar.gz}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:24f6093c1e840ca5df2eb09291a1dbf1
    rbtorrent:49f40244fc72e5821b2b4664087c0e6b5989687c
    http://pyyaml.org/download/libyaml/$FN
"

build() {
    info "Building libyaml"
    push

    run tar -xzf "${DLDIR}/${FN}" -C "${WORKDIR}"

    cd "${WORKDIR}/${FNR}"

    for ptch in $(find "${ROOT}/libraries/" -name "${FNR}_*.patch" | sort); do
        run patch -p0 -N -i "${ptch}"
    done

    run ./configure --prefix "${PREFIX}"

    make
    make install

    pop
    info "Build OK"
}
