build() {
    info "Building ticket_parser2 (TVM)"
    push
    if [[ "$(uname -p)" = "aarch64" ]]; then
        pop
        info "skipped on aarch64"
        return
    fi

    local libdir=${WORKDIR}/tvm

    # in future revs this moved to library/python/deprecated/ticket_parser2/so
    local arcdir=library/python/deprecated/ticket_parser2/so

    run rm -rf "${libdir}/"
    run mkdir "${libdir}"
    run cp -r "${ROOT}/libraries/ticket_parser2/arcadia" "${libdir}"
    run cp -r "${ROOT}/libraries/ticket_parser2/yatool" "${libdir}"

    if [[ "$(uname)" = "CYGWIN"* ]]; then
        echo "USE_ARCADIA_PYTHON=no
PYTHON_INCLUDE=-I/skynet/python/include/python2.7
PYTHON_CFLAGS=
PYTHON_LDFLAGS=
PYTHON_LIBRARIES=/skynet/python/bin/libpython2.7.dll" > "${libdir}/arcadia/local.ymake"
    else
        echo "USE_ARCADIA_PYTHON=yes" > "${libdir}/arcadia/local.ymake"
    fi

    # Save vars.
    OLDCC=${CC}
    unset CC
    OLDCXX=${CXX}
    unset CXX

    pushd "${libdir}/arcadia"

    BUILD_JOBS="${CPUCOUNT}"
    ADDITIONAL_ARGS=""
    if [ "$(uname -sp)" = "Darwin arm" ]; then
        ADDITIONAL_ARGS="--target-platform default-darwin-arm64"
    fi
    if [ "$(uname)" = "Darwin" ]; then
        BUILD_JOBS=2
    fi
    PATH="${BINDIR}:${PATH}" run ../yatool make ${arcdir} -r -DARCADIA_PYTHON_UNICODE_SIZE=2 -DALLOCATOR=SYSTEM -j"${BUILD_JOBS}" $ADDITIONAL_ARGS
    if [[ "$(uname)" = "CYGWIN"* ]]; then
        SOURCE_LIB_NAME=libticket_parser2_pymodule.pyd
        TARGET_LIB_NAME=ticket_parser2_pymodule.dll
    else
        SOURCE_LIB_NAME=ticket_parser2_pymodule.so
        TARGET_LIB_NAME=${SOURCE_LIB_NAME}
    fi

    local moddir="${PREFIX}/lib/python${PYTHONMAJORVERSION}/site-packages/ticket_parser2"
    run rm -rf "${moddir}"
    run cp -r "${arcdir}/../ticket_parser2" "${moddir}"
    run cp "${arcdir}/${SOURCE_LIB_NAME}" "${moddir}/${TARGET_LIB_NAME}"
    
    local moddir="${PREFIX}/lib/python${PYTHONMAJORVERSION}/site-packages/enum"
    run rm -rf "${moddir}"
    run cp -r "contrib/python/enum34/enum" "${moddir}"

    popd

    # Restore vars.
    export CC=${OLDCC}
    export CXX=${OLDCXX}

    pop
    info "Build OK"
}

