#!/bin/bash
# vim: tw=198

#include build_v2/_misc.sh

# TODO: env var
# TODO: pypi url
#_convert_url() {
#    if [ "${1}" = PYPI ]; then
#        echo "http://pypi.python.org/packages/source/${2:0:1}/${2%-*}/${2}"
#    else
#        echo ${1}
#    fi
#}
                #E)
                #    EXTRA=$(eval "echo ${_PY_PACKAGES[n_pack]}")
                #    let n_pack++
                #    ;;

                #C)
                #    BUILDER_FUNC=$(eval "echo ${_PY_PACKAGES[n_pack]}")
                #    let n_pack++
                #    ;;

                #O)
                #    eval ${_PY_PACKAGES[n_pack++]} || CONT=1 ;;



_PY_PACKAGES=(
    ################  ESSENTIAL
    setuptools-44.1.1.zip       build:_build_nopip   pypi
    "md5:2c41f19cfd1f16a7d7bb23689921ac1b rbtorrent:9b7f69a603918e157359afbb3ffcb1fd9ba1991d"
    --
    pip-1.4.1.tar.gz            build:_build_nopip
    "md5:71daad4f8f78632e9ac55ae2ecead834 rbtorrent:979dc9a95ef90dafee430fdad3f8df3c4be92973 https://github.com/pypa/pip/archive/\$fn"
    --
    virtualenv-1.10.1.tar.gz
    "md5:a2e9d54c0923ef2166971c8e334c2d82 rbtorrent:1aa80c4acfbfb3d42c008336d11e7b68c16228ad https://github.com/pypa/virtualenv/archive/\$fn"
    --
    wheel-0.24.0.tar.gz
    "md5:3b0d66f0d127ea8befaa5d11453107fd rbtorrent:e2d83d5630408189cb2f8121089e88aab1a63fe1 https://pypi.python.org/packages/source/w/wheel/\$fn"
    --

    ################  HEAVILY USED IN SKYNET
    Cython-0.19.2.tar.gz                             pypi
    "md5:4af1218346510b464c0a6bf15500d0e2 rbtorrent:0666d33e29d95a571f6166e55aceedb79a35a12d"
    --
    py-1.4.14.tar.gz                                 pypi
    "md5:f441639a1d3f0bbbc955cd22d8127d5e rbtorrent:72f602d0f5b1accad373a758991d4a8bf8a05b5c"
    --
    ply-3.4.tar.gz
    "md5:ffdc95858819347bf92d7c2acc074894 rbtorrent:9a7ceb782e48451acd4e5bc3251cfb24866cced7 http://www.dabeaz.com/ply/\$fn"
    --
    greenlet-1.1.0.tar.gz                            pypi
    "md5:93bd96887f84352f26d425236f27a9f6 rbtorrent:4c40a6cf0b570e6a6e2951177cc6f1483060dc91"
    --
    gevent-21.1.2.tar.gz                             pypi
    "md5:0463f4be37e551e53456c9edaeeb86fc rbtorrent:d6cb2b32d3ccca16ba775be071c5c63244e64e41"
    --
    setproctitle-1.1.10.tar.gz build:_build_nocygwin pypi
    "md5:2dcdd1b761700a5a13252fea3dfd1977 rbtorrent:bdfdc72eb5ddbacc42ab26c6e15a31b06074b97e"
    --
    msgpack-python-0.2.0.tar.gz                      pypi
    "md5:cdac1d250cf9c0f0bd36abdfe2c96f8b rbtorrent:5e8fea428b63fbeeef1d983e61d28cdf3f8b4a77"
    --
    faulthandler-2.0.tar.gz                          pypi
    "md5:1a25c270b983bbe61153509f1c744104 rbtorrent:217b5b627288835f3d27a434f1be9c2943a16337"
    --
    porto-5.0.29.tar.bz2       build:_build_porto     pypi
    "md5:0504a95929b0cfa41892f6fa8d966178 rbtorrent:64fa3d1a10f0af81d05ef91e9fe888ac8ea47d97"
    --

    #################  USED IN PRODUCTION
    Jinja2-2.6.tar.gz                                pypi
    "md5:1c49a8825c993bfdcf55bb36897d28a2 rbtorrent:2701a73fcbd2baa0f91a0a8ecae391cb77b9b9cf"
    --
    lfm-2.2.tar.gz              build:_build_nomac   
    "md5:c46385f0a5daa0a43cb0a2434a634f8b rbtorrent:6293569825ae70a35cbb34804e3ef7f7a8c3587a"
    --
    pysendfile-2.0.0.tar.gz    build:_build_nocygwin 
    "md5:bd8d96b64e7c5c5b91ea2a6659aa82a3 rbtorrent:a15c4548b77ec0f1158c926ffdef132eadaea221"
    --
    psutil-0.7.1.tar.gz        build:_build_nocygwin 
    "md5:ad7bcd473cd2a64763ed8286e279d3d7 rbtorrent:b8ac115fc241072b1bc310e2f07d7081cdf72d5b"
    --
    docutils-0.8.tar.gz         build:_build_nomac   pypi
    "md5:f57474b69bfbf0eb608706a104f92dda rbtorrent:27b3f2fdcb51fae482363a8bbfc223959d80049f"
    --
    Pygments-1.4.tar.gz         build:_build_nomac   pypi
    "md5:d77ac8c93a7fb27545f2522abe9cc462 rbtorrent:259b8e0776d5cf40b4b4792b27b411e2dd06aee7"
    --
    Sphinx-1.2b1.tar.gz         build:_build_nomac   pypi
    "md5:67bea6df63be8e2a76ebedc76d8f71a3 rbtorrent:ff222c67628072c3539b4655c28ae01012750cb2"
    --
    lockfile-0.9.1.tar.gz                            
    "md5:4e4c7ea4c4301500da5e7f3b51e01cfe rbtorrent:ce25519e5e20579c2ad58a1024daae23cd2f32a8"
    --
    pyzmq-14.7.0.tar.gz         build:_build_pyzmq   pypi
    "md5:87e3abb33af5794db5ae85c667bbf324 rbtorrent:ca140a19775e7831dbfa3bb0f8d53c99d0315a8f"
    --
    Pyro4-4.8.tar.gz                                 pypi
    "md5:22ffaeb0b921dcf0c57affb021aa4342 rbtorrent:944ac7c1ee75bdd11183d68695f1e435eddfd216"
    --
    simplejson-2.2.1.tar.gz                          pypi
    "md5:070c6467462bd63306f1756b01df6d70 rbtorrent:ac8d3a0aeab8fdaa21bf568db5eafdedaa6d3188"
    --
    pycrypto-2.5.tar.gz                              pypi
    "md5:783e45d4a1a309e03ab378b00f97b291 rbtorrent:ec44d0e90e0369a9bac2fd8474eb131c0eeb4079"
    --
    weakrefset-1.0.0.tar.gz                          pypi
    "md5:a5d93c85dd296886516528172fc512a4 rbtorrent:7395a8c89b3c4a9a9b9918bfdbe405c8c4527fff"
    --
    progressbar-2.3.tar.gz                           
    "md5:4f904e94b783b4c6e71aa74fd2432c59 rbtorrent:76b794ae4857090bb862016d0e8c7107c50eab62"
    --
    pymongo-2.7.2.tar.gz        build:_build_nomac   pypi
    "md5:bbd229fe0ff43ee130eed9ffa9db7353 rbtorrent:a6e2e2203ed54cffadcfc154fa36cd26303dc572"
    --
    zc-zookeeper-static-3.4.3-5.tar.gz build:_build_nomac_noarm pypi
    "md5:faf836349de67aeb7ceca2736ba723e8 rbtorrent:984871427daa548c9b1d50becb8ce0b7840db55e"
    --
    zope.event-4.5.0.tar.gz                          pypi
    "md5:bc38324cb29ce2d759c3cb56ea199995 rbtorrent:1eb3cf5fa8d8f372ef74d92ba5e9f973f7a1f5b1"
    --
    zope.interface-5.4.0.tar.gz                      pypi
    "md5:c58b31da83449631efb499de13c68c6a rbtorrent:e513e2c38f10f4b662a0b7e3057be83e7a5646c0"
    --
    kazoo-1.0b1.zip             build:_build_nomac   pypi
    "md5:6d0400547063ae23a1591e0301176e4e rbtorrent:e99e48ab2e9e0bad309e338041bf8972b066592b"
    --
    lxml-3.0alpha2.tar.gz       build:_build_lxml    pypi
    "md5:58410583f1dd369ccaf7fa7d452da6b5 rbtorrent:cdb424ecf666c0e04e01ff3f0a5e483451c78f76"
    --
    sysv_ipc-0.6.3.tar.gz
    "md5:622b32edd53a6a49bf363d88be1fd9a0 rbtorrent:d8dda956bc390daab5f9c547fd74b26bb793a21a http://semanchuk.com/philip/sysv_ipc/\$fn"
    --
    PyYAML-3.09.tar.gz         build:_build_pyyaml
    "md5:f219af2361e87fdc5e85e95b84c11d87 rbtorrent:372a5a73dbfa61445b693e2bd2caeb8c1a59305b http://pyyaml.org/download/pyyaml/\$fn"
    --
    protobuf-python            build:_build_protobuf local:$WORKDIR/protobuf-2.3.0/python
    --
    dnspython-1.15.0.tar.gz                          pypi
    "md5:63a679089822fb86127867c315286dc5 rbtorrent:af4ceb03ad0e1326598b1462a88e85071ecb61b4"
    --
    protobuf-3.3.0.tar.gz      build:_build_protobuf_3 pypi
    "md5:27941e8e42e83d5183605054576882dd rbtorrent:b6e40fbd724fcd8d1e29ce6725eadc71b2c96f72"
    --
    requests-2.13.0.tar.gz     build:_build_requests_2 pypi
    "md5:921ec6b48f2ddafc8bb6160957baf444 rbtorrent:2ff1672ecc0f42a335b50e83a1d745c9358a5c2f"
    --
    nanny_rpc_client-0.10.tar.gz                     pypi
    "md5:aafa6a322fb6ba1dade36235f30b9744 rbtorrent:240fa5bba8a157f8cc7180437cd7177a817408de"
    --
    clusterpb-0.10.tar.gz                            pypi
    "md5:042366f1ddef911423ca086450d90304 rbtorrent:92010870649c9d77bbc0b65fd399b122bda2d520"
    --
    xxhash-2.0.2.tar.gz                              pypi
    "md5:0895793b5861a2462b8444abb5a3ee3a rbtorrent:913ae095090968901dcf6445f8f5bdadfcdf5659"
    --

    #################  USED IN PRODUCTION (SERVICES)
    python-daemon-1.5.5.tar.gz                       pypi
    "md5:1f6cd41473c2e201021a0aeef395b2b1 rbtorrent:ad3ae49950b24ce7a4f87f8f328023f1753ec377"
    --
    Werkzeug-0.8.2.tar.gz                            pypi
    "md5:d4fcc1c9c5a4c4d148b87e5b581f9dea rbtorrent:c9c34201538a4ab9f3c260d93a8293ba865dc2db"
    --
    Flask-0.8.tar.gz                                 pypi
    "md5:a5169306cfe49b3b369086f2a63816ab rbtorrent:940f2ac819ea9f5795e89b350141c8b3ee02fc6f"
    --
    apsw-3.8.2-r1.zip
    "md5:77103c13aeed2d6802bdd72d858114c6 rbtorrent:17c2da3514d70aea868e598f97230935f911afac"
    --
    CherryPy-3.1.2.tar.gz      build:_build_nomac 
    "md5:15c60b3a91886b9a304d366fba93669c rbtorrent:2e3f89b3ced10a7a2219c06b3d73413c06f5de7e http://download.cherrypy.org/cherrypy/3.1.2/\$fn"
    --

    ################  FLASK-RESTFUL DEPS (HEARTBEAT-SERVER REST API)
    blinker-1.2.tar.gz         build:_build_nomac    pypi
    "md5:6b0a876f0778084e97935a951ea96ded rbtorrent:588aae8138172eaeadde9d489bb606f119f3d6b5"
    --
    six-1.12.0.tar.gz                                pypi
    "md5:9ae5d1feed8c0215f4ae4adcd9207fcb rbtorrent:7986251cabe010d36807bb27b294b02aadc062c1"
    --
    mock-1.0.1.tar.gz          build:_build_nomac    pypi
    "md5:c3971991738caa55ec7c356bbc154ee2 rbtorrent:f657ee26aec27aaa98555dd01c4d4c79ac7be151"
    --
    nose-1.3.7.tar.gz                                pypi
    "md5:4d3ad0ff07b61373d2cefc89c5d0b20b rbtorrent:3a6638a859067bc41e9fca5fb1318b5bfe7fa52d"
    --
    Flask-RESTful-0.2.5.tar.gz build:_build_nomac    pypi
    "md5:62144cd6d57be64bb15bc0a027679db5 rbtorrent:0e3c780a8ee65cd82c1ce208c0b317ba4b14394f"
    --

    ################ DEVELOPER TOOLS
    ipython-0.11.tar.gz                              pypi
    "md5:efc899e752a4a4a67a99575cea1719ef rbtorrent:4b714ad85cd5752ab1e70c1e566f95f0215ba2c9"
    --
    ipdb-0.6.tar.gz                                  pypi
    "md5:4a4b32e64c043522368c7871d8f50b6d rbtorrent:66fbfa0c21e9da5bc97e9681edfe5d720f2bd85e"
    --
    pudb-2012.3.tar.gz                               pypi
    "md5:d07d6622901b1addeb64e833fea5eb9b rbtorrent:11e54017fd76fa1299c49bf1db1713057513a131"
    --
    urwid-1.1.0.tar.gz                               pypi
    "md5:aa607646b260c4284a0d246abb716f00 rbtorrent:e4129f805548ed29b9210a1aebd43043107840ff"
    --
    cssselect-0.7.1.tar.gz                           pypi
    "md5:c6c5e9a2e7ca226ce03f6f67a771379c rbtorrent:adb47dc96206fa31faffe980a4ffb996b0d7ebce"
    --
    dowser-0.2.1.tar.gz          build:_build_dowser
    "md5:1b241c55f23024228f48b1a5f88b1b8c rbtorrent:7248087e59c8534d5bdbc02f57389d8995360d89 http://cmsearch00.yandex.ru/resources/skynet/skydeps/\$fn"
    --
    Pympler-0.4.2.tar.gz                             pypi
    "md5:6bdfd913ad4c94036e8a2b358e49abd7 rbtorrent:0b4935906622de6870cb7d288072f61633a12ae3"
    --

    ################  USED BY SOMEBODY ELSE
    bsddb3-5.2.0.tar.gz         build:_build_bdb     pypi
    "md5:e3031de4074fc0240a5a76a418437a85 rbtorrent:4db7fd4e23e3784fe2aa0f490f53bbead6240771"
    --
    chardet-1.0.1.tar.gz                             pypi
    "md5:7c28b02bca7847c13bebedaf4df6c5a3 rbtorrent:cf1bddcb4e7227e68d7eba94e2e7d45c65c08c53"
    --
    certifi-0.0.7.tar.gz                             pypi
    "md5:86eee1cacdf8167d7ea7ea3572d233d5 rbtorrent:752a0dd2ee5cc242375e882c03d69d2776c3c867"
    --
    requests-1.1.0.tar.gz                            pypi
    "md5:a0158815af244c32041a3147ee09abf3 rbtorrent:9babe2aabc75b9032127fdb7a4b7356c8284aa92"
    --
    grequests-0.2.0.tar.gz                           pypi
    "md5:23186795cf69d127f5e90df665d25387 rbtorrent:d429d352eea9310c7ff51805d05d507021049d41"
    --
    PyCap-0.3.4.tar.gz          build:_build_nomac   pypi
    "md5:ff22e1d705dbdb9352e77071e77de334 rbtorrent:5be76b55498858b9cab51e18ddd9857ad9e00189"
    --
    Imaging-1.1.7.tar.gz        build:_build_nomac
    "md5:fc14a54e1ce02a0225be8854bfba478e rbtorrent:42e64312d773bc8f84d89370203c1137e356b25e http://effbot.org/media/downloads/\$fn"
    --
)

_PY_PACKAGES_PARSED=( )

add_pack() {  # {{{
    local fn=$1
    local build=$2
    local uri=$3
    local local_uri=$4
    local path=

    shift 4

    [[ -z $build ]] && build=_build

    case "$1" in
        pypi)
            uri="$uri pypi://pypi.yandex-team.ru/$fn pypi://pypi.python.org/$fn"
            shift
            ;;
        '')
            ;;
        *)
            echo "unknown flag: $1"
            exit 1
            ;;
    esac

    if [[ -z $local_uri ]]; then
        DLS[${#DLS[@]}]="fn:$fn $uri"
        path="$DLDIR/$fn"
    else
        path="$local_uri"
    fi

    _PY_PACKAGES_PARSED[${#_PY_PACKAGES_PARSED[@]}]="package"
    _PY_PACKAGES_PARSED[${#_PY_PACKAGES_PARSED[@]}]="fn:$fn"
    _PY_PACKAGES_PARSED[${#_PY_PACKAGES_PARSED[@]}]="build:$build"
    _PY_PACKAGES_PARSED[${#_PY_PACKAGES_PARSED[@]}]="source:$path"
    _PY_PACKAGES_PARSED[${#_PY_PACKAGES_PARSED[@]}]="endpackage"
}
# }}}

# Parse _PY_PACKAGES into _PY_PACKAGES_PARSED {{{
for ((idx=0; idx<${#_PY_PACKAGES[@]}; idx++)); do
    item=${_PY_PACKAGES[$idx]}

    if [[ $item = -- || $idx = 0 ]]; then
        [[ $idx -gt 0 ]] && add_pack "$fn" "$build" "$uri" "$local_uri" "${flags[@]}"
        fn=
        build=
        flags=( )
        uri=
        local_uri=
        [[ $idx -gt 0 ]] && continue
    fi

    [[ -z $fn ]] && { fn=$item; continue; }

    typ=${item%%:*}
    data=${item#*:}

    case $typ in
        build)
            build=$data
            ;;
        pypi)
            flags[${#flags[@]}]=pypi
            ;;
        local)
            local_uri=$data
            ;;
        *)
            uri="$uri $item"
            ;;
    esac
done
# }}}

# Build meths {{{
_build() {
    P=$(pwd)
    cd ..
    mkdir -p "$P-temp"
    TMPDIR="$P-temp" run "${BINDIR}/python" -s "${BINDIR}/pip" \
        install \
        "$@" \
        --no-deps --no-index \
        -I \
        "${P}"
    rm -rf "$P-temp"
}

_build_nomac() {
    if [ "$(uname)" = "Darwin" ] || [[ "$(uname)" = "CYGWIN"* ]]; then
        return
    fi
    _build
}

_build_nomac_noarm() {
    if [ "$(uname -p)" = "aarch64" ]; then
        return
    fi
    _build_nomac
}

_build_nocygwin() {
    if [[ "$(uname)" = "CYGWIN"* ]]; then
        return
    fi
    _build
}

_build_nopip() {
    run "${BINDIR}/python" -c '__import__("setuptools"); execfile("setup.py", dict(__name__="__main__", __file__="setup.py"))' install --single-version-externally-managed --record=filelist.txt
}

_build_bdb() {
    BERKELEYDB_DIR=${PREFIX} _build "$@"
}

_build_pyzmq() {
    if [ "$(uname)" = "Darwin" ] || [[ "$(uname)" = "CYGWIN"* ]]; then
        return
    fi
    _build \
        --install-option='--zmq=bundled'
}

_build_lxml() {
    XSLT_CONFIG=${BINDIR}/xslt-config _build "$@"
}

_build_pyyaml() {
    echo "include_dirs=$INCDIR" >> setup.cfg
    echo "library_dirs=$LIBDIR" >> setup.cfg
    _build
}

_build_protobuf() {
    rm -rf "${WORKDIR}/protobuf-python"
    cd "${WORKDIR}/protobuf-2.3.0/python"
    for chr in '"' "I" " "; do
        sed -i -e "s|${chr}../src|${chr}../../src|g" setup.py
    done
    _build
}

_build_protobuf_3() {
    mv google/protobuf google/protobuf_3_3_0
    _build
}

_build_requests_2() {
    mv requests requests_2_13_0
    _build
}

_build_porto() {
    cd "${WORKDIR}/porto-5.0.29/"
    run cp src/rpc.proto src/api/python/porto/
    cd src/api/python
    PATH="${BINDIR}:${PATH}" _build
}

_build_dowser() {
    echo "
from setuptools import setup

setup(
    name='dowser',
    version='9999-r137',
    author='torkve',
    author_email='torkve@yandex-team.ru',
    url='https://github.com/torkve/dowser',
    license='PSF',
    packages=['dowser'],
    package_dir={'': 'src'},
    package_data={
        '': [
            'graphs.html',
            'main.css',
            'trace.html',
            'tracemalloc.html',
            'tree.html',
        ]
    },
    include_package_data=True,
    zip_safe=False,
)
" > setup.py
    _build
}
# }}}

build_package() {  # {{{
    local fn=$1
    local build=$2
    local path=$3
    local fnr=$fn

    info "Installing $fn"
    push

    if [[ -d "$path" ]]; then
        run rm -rf "$WORKDIR/$fnr"
        run cp -r "$path" "$WORKDIR/$fnr"
    else
        for postfix in .tar.gz .tar.bz2 .tgz .tbz2 .zip; do
            fnr=${fn%$postfix}
            if [[ "$fnr" != "$fn" ]]; then 
                rm -rf "$WORKDIR/$fnr"
                case $postfix in
                    .tar.gz|.tgz)
                        run tar -xzf "$DLDIR/$fn" -C "$WORKDIR"             ;;
                    .tar.bz2|.tbz2)
                        run tar -xjf "$DLDIR/$fn" -C "$WORKDIR"             ;;
                    .zip)
                        run "$BINDIR/unzip" -o -d "$WORKDIR" "$DLDIR/$fn"     ;;
                    *)
                        echo "UNKNOWN POSTFIX! $postfix"
                        exit 1
                esac
                break
            fi
        done
        [[ "$fnr" = "$fn" ]] && { info "Not supported file format: $fn"; exit 1; }
    fi

    # If some have archive with d--------- perms (ehh..), fix it
    chmod u+rwx "$WORKDIR/$fnr"
    find "$WORKDIR/$fnr" -type d -exec chmod u+rwx {} \;
    find "$WORKDIR/$fnr" -type f -exec chmod u+rw {} \;

    cd "$WORKDIR/$fnr"

    local ptch
    for ptch in $(find "$ROOT/libraries" -name "${fnr}_*patch" | sort); do
        run patch -p0 -N -i "$ptch"
    done

    [[ -z $build ]] && { echo "No builder func defined"; exit 1; }

    eval "$build"

    if [ "$(uname)" = "Darwin" ]; then
        find "$LIBDIR/python2.7/site-packages" -name '*.so' -maxdepth 1 -mindepth 1 -print0 | xargs -0n1 install_name_tool -change skynet/libpython2.7.dylib @loader_path/../../libpython2.7.dylib
        find "$LIBDIR/python2.7/site-packages" -name '*.so' -maxdepth 2 -mindepth 2 -print0 | xargs -0n1 install_name_tool -change skynet/libpython2.7.dylib @loader_path/../../../libpython2.7.dylib
        find "$LIBDIR/python2.7/site-packages" -name '*.so' -maxdepth 3 -mindepth 3 -print0 | xargs -0n1 install_name_tool -change skynet/libpython2.7.dylib @loader_path/../../../../libpython2.7.dylib
    fi
    pop
    info "Done"
} # }}}

build() { # {{{
    for pack in "${_PY_PACKAGES_PARSED[@]}"; do
        if [[ $pack = package ]]; then
            local fn=
            local build=
            local path=
            continue
        elif [[ $pack = endpackage ]]; then
            build_package "$fn" "$build" "$path"
            continue
        fi

        local key=${pack%%:*}
        local value=${pack#*:}

        case $key in
            fn)
                fn=$value
                ;;
            build)
                build=$value
                ;;
            source)
                path=$value
                ;;
            *)
                echo "Unknown key $key with value $value"
                exit 1
                ;;
        esac
    done

    if [[ "$(uname)" = "CYGWIN"* ]]; then
        # remove {xml2,xslt}-config files
        run rm "${BINDIR}/{xml2,xslt}-config"
    fi
} # }}}
