FN=v8-3.9.24.21.tar.bz2
FNR=${FN%.tar.bz2}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:4c9c54f65e581c5dbc64f89104ec4e39
    rbtorrent:1f2334e846db43a58f18bc037c4109d6b4e6f09f
    http://commondatastorage.googleapis.com/chromium-browser-official/$FN
"

build() {
    info "Building v8"
    push

    info "Ignored"
    pop

    return

    rm -rf "${WORKDIR}/${FNR}"
    run tar -xjf "${DLDIR}/${FN}" -C "${WORKDIR}"
    cd "${WORKDIR}/${FNR}"

    for ptch in $(find "${ROOT}/libraries/" -name "${FNR}_*.patch" | sort); do
        run patch -p0 -N -i "${ptch}"
    done

    CARCH=$("${BINDIR}/python" -c 'import sys; print "x64" if sys.argv[1].endswith("amd64") else "ia32"' "$ARCH")

    # Need to remove this because build will fail against old v8
    rm -rf "${INCDIR}/v8"
    rm -rf "${LIBDIR}"/libv8*

    run "${BINDIR}/python" "${BINDIR}/scons" \
        -j "${CPUCOUNT}" \
        arch="${CARCH}" \
        debuggersupport=off snapshot=off profilingsupport=off \
        library=shared

    run "${BINDIR}/python" "${BINDIR}/scons" \
        -j "${CPUCOUNT}" \
        arch="${CARCH}" \
        debuggersupport=off snapshot=off profilingsupport=off \
        library=static

    [ -e libv8.so ] && cp -r libv8*.so "${LIBDIR}"
    [ -e libv8.a ] && cp -r libv8*.a "${LIBDIR}"
    cp -r include "${INCDIR}/v8"

    pop
    info "Build OK"
}
