FN=mongodb-src-r2.1.1.tar.gz
FNR=${FN%.tar.gz}

DLS[${#DLS[@]}]="
    fn:$FN
    md5:2e1dbd51df1c053f907dc70a99794e1e
    rbtorrent:e01866029851c81fb96c7ae1cef2f455dc56d4c8
    http://downloads.mongodb.org/src/$FN
"

build() {
    info "Building MongoDB"
    push

    info "Ignored"
    pop

    return

    rm -rf "${WORKDIR}/${FNR}"
    run tar -xzf "${DLDIR}/${FN}" -C "${WORKDIR}"

    cd "${WORKDIR}/${FNR}"

    for ptch in $(find "${ROOT}/libraries/" -name "${FNR}_*.patch" | sort); do
        run patch -p0 -N -i "${ptch}"
    done

    CARCH=$(${BINDIR}/python -c 'import sys; print "--64" if sys.argv[1].endswith("amd64") else "--32"' "$ARCH")

    if [ "$(uname)" = "FreeBSD" ]; then
        TARGETS="mongod mongos"
    else
        TARGETS="all"
    fi

    run "${BINDIR}/python" "${BINDIR}/scons" \
        -j "${CPUCOUNT}" \
        "${CARCH}" \
        --cc="${CC}" \
        --cxx="${CXX}" \
        --no-glibc-check \
        --release \
        --prefix="${PREFIX}" \
        ${TARGETS}

    run rm -rf "${BINDIR}"/mongo{d,s}
    for f in $(ls mongo{,d*,e*,f*,i*,o*,p*,r*,s*,t*} 2>/dev/null); do
        run cp "$f" "${BINDIR}"
    done

    pop
    info "Build OK"
}
