cleanup_elf() {
    local fn="$1"
    local debugfn="${fn}.dsym"
    strip --only-keep-debug "$fn" -o "$debugfn" 2>/dev/null || return
    chmod 0755 "$fn"
    strip -s "$fn"
    if objcopy --add-gnu-debuglink="$debugfn" "$fn" 2>/dev/null; then
        info "added debuglink to $fn"
    else
        true
    fi
}

cleanup_build() {
    info "Cleanup"
    push

    cd "${WORKDIR}/skynet/python"

    cd include
    for item in *; do
        if [ ! "${item}" = "python${PYTHONMAJORVERSION}" ]; then
            run rm -rf "${item}";
        fi
    done
    cd ..

    run rm -rf share
    run rm -rf docs
    run rm -rf lib/*.{a,la}

    info "Drop all lib.so.VER -> lib.so symlinks and recreate for all libs"
    cd lib/
    find . -maxdepth 1 -name \*.so -type l -delete

    if [ "$(uname)" = "Linux" ]; then
        SED_="${SED} -r"
    else
        SED_="${SED} -E"
    fi
    for libname in lib*.so.*; do
        ln -sf "${libname}" $(echo "${libname}" | ${SED_} -e 's/lib(.*).so.(.*)/lib\1.so/')
    done
    cd ..

    info "Drop share in IPython"
    rm -rf lib/python2.*/site-packages/ipython-*/share

    info "Strip and cleanup elfs"
    set +e
    local _tmp_ldlibpath="$LD_LIBRARY_PATH"
    export LD_LIBRARY_PATH=  # reset, because strip/objdump/etc can accidentially load our libs
    for fn in $(find . -type f -not -name '*.debug' -not -name '*.a' -not -name '*.o' -not -name '*.exe'); do
        cleanup_elf "$fn"
    done
    export LD_LIBRARY_PATH="$_tmp_ldlibpath"
    set -e

    info "Set 0755 on python/bin/*"
    find bin -type f -exec chmod 0755 {} \;

    info "Set 0755 on all dirs in python/lib"
    find lib -type d -exec chmod 0755 {} \;

    info "Set 0755 on all executables in python/lib"
    if [ "$(uname)" = "FreeBSD" ] || [ "$(uname)" = "Darwin" ]; then
        permpred="+"
    else
        permpred="/"
    fi

    find lib -type f -perm ${permpred}0111 -exec chmod 0755 {} \;

    info "Set 0644 on all non-executables in python/lib"
    find lib -type f -not -perm ${permpred}0111 -exec chmod 0644 {} \;

    info "Remove py2-incompatible .py files"
    rm lib/python2.7/site-packages/gevent/_socket3.py

    pop
    info "Done"
}
