#!/usr/bin/env bash

include() {
    local VARNAME=${1//\//g}
    VARNAME=${VARNAME/./}
    eval VARVAL='$'${VARNAME}

    if [ -e ${VARVAL} ]; then
        source "$1"
        eval ${VARNAME}=1
    fi
}

set -e
umask 022

include build_v2/_utils.sh
include build_v2/_config.sh
include build_v2/_gcc.sh
include build_v2/_print.sh
include build_v2/_misc.sh

set +e
findgcc

if [ ! $? -eq 0 ]; then
    echo "Cant find suitable GCC version!" >&2
    exit 1
fi
set -e

# SYSTEM and ARCH will be set
detectarch
detect_version

# Functions
include build_v2/_f_run.sh
include build_v2/_f_make.sh
include build_v2/_f_dl.sh

info "Using workdir: ${WORKDIR}"
info "Using gcc: $(${CC} --version | head -n 1)"
info "Using g++: $(${CXX} --version | head -n 1)"
info "CPU count: ${CPUCOUNT}"
info "Platform: ${SYSTEM}"
info "Architecture: ${ARCH}"
info "CFLAGS: ${CFLAGS}"
info "CXXFLAGS: ${CXXFLAGS}"
info "LDFLAGS: ${LDFLAGS} (we use RPATH anyway)"


rm -rf ${SKYDIR}/share/python-deps
copy_missing_libraries

START_FROM=${1:-0}
STEPS=()
COUNT=0

stepinfo() {
    info "Step #$1: ${2##*/}"
}

for step_filename in build_v2/steps/_build_*.sh; do
    let COUNT+=1
    [[ $COUNT -ge $START_FROM || $COUNT = 3 ]] || continue
    STEPS[$COUNT]="$step_filename"
done

info "Preparing build steps..."
push
for step in ${!STEPS[@]}; do
    step_file=${STEPS[$step]}
    stepinfo $step $step_file
    push

    unset DLS
    declare -a DLS

    source "$step_file"

    for fn in ${!DLS[@]}; do
        dlinfo=(${DLS[$fn]})
        dl "${dlinfo[@]}"
    done
    pop
done
pop
info "Done"

info "Running build steps..."
push

_PWD=$(pwd)
for step in ${!STEPS[@]}; do
    step_file=${STEPS[$step]}
    stepinfo $step $stepfile

    push
    source "$step_file"
    build
    cd ${_PWD}
    pop
done

pop
info "Done"

include build_v2/steps/_cleanup_build.sh

fixrpath

# Run our little test before cleanup and after
# so, if something fails we can continue with full build dir
little_test

add_extra
update_shebangs
fix_darwin_rpath
cleanup_build
remake_pyco
little_test

make_distributive
cleanup_workdir

echo
echo "----------- BUILD COMPLETE ------------"
